﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class ENC_ENCOUNTERDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public ENC_ENCOUNTERDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public List<ENC_ENCOUNTER> GetItemsByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<ENC_ENCOUNTER> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_ENC_ENCOUNTER_getitemsByReferral", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);
                sCmd.Parameters.AddWithValue("@REFERRAL_ID", REFERRAL_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    var myData = objTemp.Tables[0].AsEnumerable().Select(r => ParseReader(r));
                    if (myData != null)
                    {
                        objReturn = myData.ToList<ENC_ENCOUNTER>();
                    }
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public ENC_ENCOUNTER ParseReader(DataRow row)
        {
            ENC_ENCOUNTER objReturn = new ENC_ENCOUNTER
            {
                AGENTORANGEFLAG = (string)GetNullableObject(row.Field<object>("AGENTORANGEFLAG")),
                AmbEncSID = (Int64)GetNullableObject(row.Field<object>("AmbEncSID")),
                APPOINTMENTTYPE = (string)GetNullableObject(row.Field<object>("APPOINTMENTTYPE")),
                CLINICSTOP = (Int16?)GetNullableObject(row.Field<object>("CLINICSTOP")),
                CLINICSTOPSID = (Int32?)GetNullableObject(row.Field<object>("CLINICSTOPSID")),
                COMBATFLAG = (string)GetNullableObject(row.Field<object>("COMBATFLAG")),
                Created = (DateTime?)GetNullableObject(row.Field<object>("Created")),
                CreatedBy = (string)GetNullableObject(row.Field<object>("CreatedBy")),
                CREDITSTOP = (Int16?)GetNullableObject(row.Field<object>("CREDITSTOP")),
                CREDITSTOPSID = (Int32?)GetNullableObject(row.Field<object>("CREDITSTOPSID")),
                DELETEFLAG = (string)GetNullableObject(row.Field<object>("DELETEFLAG")),
                DIVISIONSID = (Int16?)GetNullableObject(row.Field<object>("DIVISIONSID")),
                ELIGIBILITYCODE = (string)GetNullableObject(row.Field<object>("ELIGIBILITYCODE")),
                ENCOUNTERDATESID = (Int32?)GetNullableObject(row.Field<object>("ENCOUNTERDATESID")),
                ENCOUNTERDATETIME = (DateTime?)GetNullableObject(row.Field<object>("ENCOUNTERDATETIME")),
                ENCOUNTERID = (string)GetNullableObject(row.Field<object>("ENCOUNTERID")),
                ENCOUNTERTIMESID = (Int32?)GetNullableObject(row.Field<object>("ENCOUNTERTIMESID")),
                ENCOUNTERTYPEINOUT = (string)GetNullableObject(row.Field<object>("ENCOUNTERTYPEINOUT")),
                ENVIRONMENTALCONTAMINANTSFLAG = (string)GetNullableObject(row.Field<object>("ENVIRONMENTALCONTAMINANTSFLAG")),
                ETLBATCHID = (Int32?)GetNullableObject(row.Field<object>("ETLBATCHID")),
                HOMELESSFLAG = (string)GetNullableObject(row.Field<object>("HOMELESSFLAG")),
                INPATADMISSIONDATE = (DateTime?)GetNullableObject(row.Field<object>("INPATADMISSIONDATE")),
                IONIZINGRADIATIONFLAG = (string)GetNullableObject(row.Field<object>("IONIZINGRADIATIONFLAG")),
                LOCATIONOFVISITCODE = (byte?)GetNullableObject(row.Field<object>("LOCATIONOFVISITCODE")),
                MOSTRECENTTRANSMITDATE = (DateTime?)GetNullableObject(row.Field<object>("MOSTRECENTTRANSMITDATE")),
                MSTFLAG = (string)GetNullableObject(row.Field<object>("MSTFLAG")),
                NOSETHROATRADIUMFLAG = (string)GetNullableObject(row.Field<object>("NOSETHROATRADIUMFLAG")),
                ORIGINALTRANSMITDATE = (DateTime?)GetNullableObject(row.Field<object>("ORIGINALTRANSMITDATE")),
                PATIENTIEN = (string)GetNullableObject(row.Field<object>("PATIENTIEN")),
                PATIENTSID = (Int32)GetNullableObject(row.Field<object>("PATIENTSID")),
                PURPOSEOFVISIT = (string)GetNullableObject(row.Field<object>("PURPOSEOFVISIT")),
                SERVICECONNECTEDFLAG = (string)GetNullableObject(row.Field<object>("SERVICECONNECTEDFLAG")),
                STA3N = (Int16?)GetNullableObject(row.Field<object>("STA3N")),
                STA6A = (string)GetNullableObject(row.Field<object>("STA6A")),
                StdRegistryId = (Int32?)GetNullableObject(row.Field<object>("StdRegistryId")),
                TRANSMITCOUNT = (Int16?)GetNullableObject(row.Field<object>("TRANSMITCOUNT")),
                Updated = (DateTime?)GetNullableObject(row.Field<object>("Updated")),
                UpdatedBy = (string)GetNullableObject(row.Field<object>("UpdatedBy"))
            };

            return objReturn;
        }

        #endregion
    }
}
